<?php
session_start();
include 'config.php';

// Simulasikan Login Admin (Ganti dengan logic login admin Anda yang sebenarnya)
// if(!isset($_SESSION['admin_logged_in'])) { header("Location: login_admin.php"); exit(); }

// ==========================================
// HANDLE LOGIC
// ==========================================

// 1. HANDLE BROADCAST
if (isset($_POST['action']) && $_POST['action'] == 'broadcast_add') {
    $title = $conn->real_escape_string($_POST['title']);
    $msg = $conn->real_escape_string($_POST['message']);
    $conn->query("INSERT INTO admin_messages (title, message) VALUES ('$title', '$msg')");
    header("Location: admin.php?page=broadcast"); exit();
}
if (isset($_POST['action']) && $_POST['action'] == 'broadcast_delete') {
    $id = intval($_POST['id']);
    $conn->query("DELETE FROM admin_messages WHERE id=$id");
    $conn->query("DELETE FROM message_reads WHERE message_id=$id");
    header("Location: admin.php?page=broadcast"); exit();
}

// 2. HANDLE WITHDRAW SETTINGS (ON/OFF)
if (isset($_POST['action']) && $_POST['action'] == 'toggle_withdraw') {
    $status = $_POST['status']; // 'on' atau 'off'
    // Cek apakah key sudah ada, jika belum insert, jika sudah update
    $cek = $conn->query("SELECT id FROM settings WHERE setting_key = 'withdraw_status'");
    if($cek->num_rows > 0) {
        $conn->query("UPDATE settings SET setting_value = '$status' WHERE setting_key = 'withdraw_status'");
    } else {
        $conn->query("INSERT INTO settings (setting_key, setting_value) VALUES ('withdraw_status', '$status')");
    }
    header("Location: admin.php?page=withdraw"); exit();
}

// 3. HANDLE APPROVE WITHDRAW (Simulasi)
if (isset($_POST['action']) && $_POST['action'] == 'approve_wd') {
    $wd_id = intval($_POST['wd_id']);
    $conn->query("UPDATE transactions SET status = 'success' WHERE id = $wd_id");
    header("Location: admin.php?page=withdraw"); exit();
}

// AMBIL DATA
$page = isset($_GET['page']) ? $_GET['page'] : 'broadcast';
$wd_status = $conn->query("SELECT setting_value FROM settings WHERE setting_key='withdraw_status'")->fetch_assoc()['setting_value'] ?? 'on';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel Unified</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 font-sans text-gray-800">

    <div class="flex min-h-screen">
        <div class="w-64 bg-slate-900 text-white flex flex-col">
            <div class="p-6 text-2xl font-bold text-center border-b border-slate-700">Admin Panel</div>
            <nav class="flex-1 p-4 space-y-2">
                <a href="?page=broadcast" class="block p-3 rounded hover:bg-slate-700 <?php echo $page=='broadcast'?'bg-slate-700':''; ?>">
                    <i class="fas fa-bullhorn w-6"></i> Broadcast
                </a>
                <a href="?page=withdraw" class="block p-3 rounded hover:bg-slate-700 <?php echo $page=='withdraw'?'bg-slate-700':''; ?>">
                    <i class="fas fa-money-bill-wave w-6"></i> Approve Withdraw
                </a>
            </nav>
        </div>

        <div class="flex-1 p-8">
            
            <?php if($page == 'broadcast'): ?>
                <h2 class="text-3xl font-bold mb-6">Kelola Broadcast Pesan</h2>
                
                <div class="bg-white p-6 rounded-xl shadow-md mb-8">
                    <h3 class="font-bold text-lg mb-4">Buat Pesan Baru</h3>
                    <form method="POST" class="space-y-4">
                        <input type="hidden" name="action" value="broadcast_add">
                        <div>
                            <label class="block text-sm font-bold mb-1">Judul</label>
                            <input type="text" name="title" class="w-full border p-2 rounded" required>
                        </div>
                        <div>
                            <label class="block text-sm font-bold mb-1">Isi Pesan</label>
                            <textarea name="message" class="w-full border p-2 rounded h-24" required></textarea>
                        </div>
                        <button class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Kirim Pesan</button>
                    </form>
                </div>

                <div class="bg-white p-6 rounded-xl shadow-md">
                    <h3 class="font-bold text-lg mb-4">Riwayat Pesan</h3>
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="border-b bg-gray-50">
                                <th class="p-3">Tanggal</th>
                                <th class="p-3">Judul</th>
                                <th class="p-3">Isi</th>
                                <th class="p-3">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $msgs = $conn->query("SELECT * FROM admin_messages ORDER BY created_at DESC");
                            while($m = $msgs->fetch_assoc()): 
                            ?>
                            <tr class="border-b hover:bg-gray-50">
                                <td class="p-3 text-sm text-gray-500"><?php echo $m['created_at']; ?></td>
                                <td class="p-3 font-bold"><?php echo $m['title']; ?></td>
                                <td class="p-3 text-sm"><?php echo substr($m['message'], 0, 50); ?>...</td>
                                <td class="p-3">
                                    <form method="POST" onsubmit="return confirm('Hapus?');">
                                        <input type="hidden" name="action" value="broadcast_delete">
                                        <input type="hidden" name="id" value="<?php echo $m['id']; ?>">
                                        <button class="text-red-500 hover:text-red-700"><i class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>


            <?php if($page == 'withdraw'): ?>
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-3xl font-bold">Approval Withdraw</h2>
                    
                    <div class="bg-white p-3 rounded-lg shadow flex items-center gap-3">
                        <span class="text-sm font-bold uppercase text-gray-500">Status Withdraw:</span>
                        <form method="POST">
                            <input type="hidden" name="action" value="toggle_withdraw">
                            <?php if($wd_status == 'on'): ?>
                                <button name="status" value="off" class="bg-green-500 text-white px-4 py-1 rounded-full font-bold text-xs shadow hover:bg-green-600 transition">
                                    <i class="fas fa-toggle-on mr-1"></i> ACTIVE
                                </button>
                            <?php else: ?>
                                <button name="status" value="on" class="bg-red-500 text-white px-4 py-1 rounded-full font-bold text-xs shadow hover:bg-red-600 transition animate-pulse">
                                    <i class="fas fa-toggle-off mr-1"></i> NON-ACTIVE
                                </button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-xl shadow-md">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="border-b bg-gray-50">
                                <th class="p-3">User</th>
                                <th class="p-3">Amount</th>
                                <th class="p-3">Bank Info</th>
                                <th class="p-3">Status</th>
                                <th class="p-3">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $wds = $conn->query("SELECT t.*, u.username FROM transactions t JOIN users u ON t.user_id = u.id WHERE t.type='withdraw' ORDER BY t.created_at DESC");
                            while($row = $wds->fetch_assoc()): 
                            ?>
                            <tr class="border-b hover:bg-gray-50">
                                <td class="p-3 font-bold"><?php echo $row['username']; ?></td>
                                <td class="p-3"><?php echo number_format($row['amount']); ?></td>
                                <td class="p-3 text-xs text-gray-500"><?php echo $row['description']; ?></td>
                                <td class="p-3">
                                    <?php if($row['status']=='pending'): ?>
                                        <span class="bg-yellow-100 text-yellow-600 px-2 py-1 rounded text-xs font-bold">Pending</span>
                                    <?php elseif($row['status']=='success'): ?>
                                        <span class="bg-green-100 text-green-600 px-2 py-1 rounded text-xs font-bold">Success</span>
                                    <?php endif; ?>
                                </td>
                                <td class="p-3">
                                    <?php if($row['status']=='pending'): ?>
                                    <form method="POST">
                                        <input type="hidden" name="action" value="approve_wd">
                                        <input type="hidden" name="wd_id" value="<?php echo $row['id']; ?>">
                                        <button class="bg-blue-500 text-white px-3 py-1 rounded text-xs hover:bg-blue-600">Approve</button>
                                    </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

        </div>
    </div>
</body>
</html>