<?php
session_start();
include '../config.php';

// Redirect jika sudah login
if (isset($_SESSION['admin_logged_in'])) {
    if($_SESSION['admin_role'] == 'branch') {
        header("Location: project.php");
    } else {
        header("Location: index.php");
    }
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $conn->real_escape_string($_POST['username']);
    $password = $_POST['password'];

    $q = $conn->query("SELECT * FROM admins WHERE username = '$username'");
    if ($q->num_rows > 0) {
        $row = $q->fetch_assoc();
        // Verifikasi Password Hash
        if (password_verify($password, $row['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $row['id'];
            $_SESSION['admin_role'] = $row['role'];
            $_SESSION['admin_name'] = $row['full_name'];
            
            if($row['role'] == 'branch') {
                header("Location: project.php");
            } else {
                header("Location: index.php");
            }
            exit();
        } else {
            $error = "Password salah.";
        }
    } else {
        $error = "Username tidak ditemukan.";
    }
}
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 dark:bg-darkbg h-screen flex items-center justify-center font-sans">
    <div class="bg-white dark:bg-slate-800 p-8 rounded-2xl shadow-xl w-full max-w-sm border border-gray-200 dark:border-slate-700">
        <h2 class="text-2xl font-bold text-center mb-6 text-gray-800 dark:text-white">Admin Portal</h2>
        
        <?php 
        // Load Logo
        $qSet = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'site_logo'");
        $logo = ($qSet->num_rows > 0) ? "../uploads/".$qSet->fetch_assoc()['setting_value'] : null;
        if($logo && file_exists($logo)): ?>
            <img src="<?php echo $logo; ?>" class="w-20 h-20 mx-auto mb-6 rounded-full object-cover border-4 border-gray-100 dark:border-slate-700">
        <?php else: ?>
            <div class="w-20 h-20 mx-auto mb-6 rounded-full bg-primary flex items-center justify-center text-white text-3xl font-bold shadow-lg">A</div>
        <?php endif; ?>

        <?php if($error): ?>
            <div class="bg-red-100 text-red-600 p-3 rounded-lg mb-4 text-sm text-center font-bold border border-red-200"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST" class="space-y-5">
            <div>
                <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Username</label>
                <div class="relative">
                    <span class="absolute left-3 top-3 text-gray-400"><i class="fas fa-user"></i></span>
                    <input type="text" name="username" required class="w-full bg-white border border-gray-300 rounded-lg p-3 pl-10 focus:ring-2 focus:ring-primary outline-none transition text-gray-800" placeholder="Username">
                </div>
            </div>
            <div>
                <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Password</label>
                <div class="relative">
                    <span class="absolute left-3 top-3 text-gray-400"><i class="fas fa-lock"></i></span>
                    <input type="password" name="password" id="passInput" required class="w-full bg-white border border-gray-300 rounded-lg p-3 pl-10 pr-10 focus:ring-2 focus:ring-primary outline-none transition text-gray-800" placeholder="Password">
                    <button type="button" onclick="togglePass()" class="absolute right-3 top-3 text-gray-400 hover:text-gray-600 focus:outline-none">
                        <i class="fas fa-eye" id="eyeIcon"></i>
                    </button>
                </div>
            </div>
            <button type="submit" class="w-full bg-primary hover:bg-emerald-600 text-white font-bold py-3 rounded-xl shadow-lg transition transform active:scale-95">LOGIN MASUK</button>
        </form>
        <p class="text-xs text-center mt-6 text-gray-400">Restricted Access Area &copy; <?php echo date('Y'); ?></p>
    </div>

    <script>
        function togglePass() {
            const input = document.getElementById('passInput');
            const icon = document.getElementById('eyeIcon');
            if (input.type === "password") {
                input.type = "text";
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = "password";
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>