<?php
session_start();
include 'config.php';

// Cek Login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php"); exit();
}

$user_id = $_SESSION['user_id'];

// 1. Ambil Transaksi (Urutkan dari yang terbaru)
$sql = "SELECT * FROM transactions WHERE user_id = $user_id ORDER BY created_at DESC";
$result = $conn->query($sql);

// 2. Hitung Total Bonus (Semua tipe bonus)
$sqlTotal = "SELECT SUM(amount) as total_bonus FROM transactions WHERE user_id = $user_id AND type LIKE 'bonus%'";
$resTotal = $conn->query($sqlTotal)->fetch_assoc();
$total_bonus = $resTotal['total_bonus'] ?? 0;

// SET MENU AKTIF (Untuk Footer Nav)
$active_menu = 'history';
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction History</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 dark:bg-darkbg text-gray-800 dark:text-gray-200 transition-colors duration-300">

    <div class="max-w-md mx-auto min-h-screen relative shadow-2xl bg-white dark:bg-slate-900 pb-24">
        
        <div class="sticky top-0 z-30 bg-white/90 dark:bg-slate-900/90 backdrop-blur-md border-b dark:border-slate-800 p-4 flex items-center justify-between shadow-sm">
            <div class="flex items-center">
                <a href="dashboard.php" class="mr-4 text-gray-500 hover:text-primary transition"><i class="fas fa-arrow-left"></i></a>
                <h1 class="font-bold text-lg">Riwayat</h1>
            </div>
            
            <div class="flex flex-col items-end">
                <span class="text-[10px] text-gray-400 uppercase tracking-wide">Total Bonus</span>
                <span class="text-[9px] text-gray-400 font-mono -mt-0.5 mb-0.5">[Sponsor-Pairing]</span>
                <span class="font-bold text-emerald-500 text-sm">Rp <?php echo number_format($total_bonus); ?></span>
            </div>
        </div>

        <div class="p-4 space-y-3">
            <?php if ($result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <?php 
                        // Logic Warna & Icon
                        // Menentukan mana yang dianggap PEMASUKAN (Warna Hijau / +)
                        // UPDATE: Menambahkan 'transfer_in' ke dalam array ini
                        $is_income = in_array($row['type'], [
                            'topup', 
                            'transfer_in', // <-- FIX: Agar Transfer Masuk jadi Hijau
                            'bonus_sponsor', 
                            'bonus_pairing', 
                            'bonus_royalty',
                            'bonus_stokis',
                            'bonus_crowd',
                            'bonus_crypto',
                            'profit_sharing'
                        ]);

                        $amount_color = $is_income ? 'text-green-500' : 'text-red-500';
                        $sign = $is_income ? '+' : '-';
                        
                        // Icon Type Logic
                        $icon = 'fa-exchange-alt';
                        $bg_icon = 'bg-slate-100 dark:bg-slate-800';
                        
                        // Kustomisasi Icon berdasarkan tipe
                        if($row['type'] == 'topup') {
                            $icon = 'fa-plus-circle'; 
                            $bg_icon = 'bg-orange-100 text-orange-500';
                        }
                        elseif(strpos($row['type'], 'bonus') !== false || $row['type'] == 'profit_sharing') {
                            $icon = 'fa-gift';
                            $bg_icon = 'bg-green-100 text-green-500';
                        }
                        elseif($row['type'] == 'withdraw') {
                            $icon = 'fa-paper-plane';
                            $bg_icon = 'bg-blue-100 text-blue-500';
                        }
                        elseif(strpos($row['type'], 'buy_') !== false) {
                            $icon = 'fa-shopping-cart';
                            $bg_icon = 'bg-red-100 text-red-500';
                        }
                        elseif($row['type'] == 'transfer_in') { // Icon Khusus Transfer Masuk
                            $icon = 'fa-arrow-down';
                            $bg_icon = 'bg-emerald-100 text-emerald-500';
                        }
                        elseif($row['type'] == 'transfer_out') { // Icon Khusus Transfer Keluar
                            $icon = 'fa-arrow-up';
                            $bg_icon = 'bg-red-100 text-red-500';
                        }
                        
                        // Format Tanggal & Jam Lengkap
                        $date_full = date('d M Y', strtotime($row['created_at']));
                        $time_full = date('H:i', strtotime($row['created_at']));
                    ?>
                    
                    <div class="flex items-start justify-between p-4 bg-white dark:bg-slate-800 rounded-2xl border border-gray-100 dark:border-slate-700 shadow-sm hover:shadow-md transition">
                        <div class="flex items-start gap-3 w-3/4">
                            <div class="w-10 h-10 rounded-full <?php echo $bg_icon; ?> flex-shrink-0 flex items-center justify-center mt-1">
                                <i class="fas <?php echo $icon; ?>"></i>
                            </div>
                            
                            <div>
                                <p class="text-[10px] font-bold uppercase tracking-wider text-gray-400 mb-0.5">
                                    <?php echo str_replace('_', ' ', $row['type']); ?>
                                </p>
                                
                                <p class="text-sm font-semibold leading-snug mb-1 text-gray-800 dark:text-gray-200 line-clamp-2">
                                    <?php echo $row['description']; ?>
                                </p>
                                
                                <div class="flex items-center gap-3 text-[10px] text-gray-400">
                                    <span><i class="far fa-calendar-alt mr-1"></i><?php echo $date_full; ?></span>
                                    <span><i class="far fa-clock mr-1"></i><?php echo $time_full; ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="text-right w-1/4 flex flex-col items-end">
                            <p class="font-bold text-sm <?php echo $amount_color; ?> whitespace-nowrap">
                                <?php echo $sign; ?> <?php echo number_format($row['amount']); ?>
                            </p>
                            
                            <span class="inline-block mt-2 text-[9px] px-2 py-0.5 rounded-full uppercase font-bold tracking-wide
                                <?php echo ($row['status'] == 'success') ? 'bg-green-100 text-green-600' : 
                                          (($row['status'] == 'pending') ? 'bg-yellow-100 text-yellow-600' : 'bg-red-100 text-red-600'); ?>">
                                <?php echo $row['status']; ?>
                            </span>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="flex flex-col items-center justify-center py-20 text-gray-400 opacity-50">
                    <div class="w-20 h-20 bg-gray-100 dark:bg-slate-800 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-file-invoice-dollar text-3xl"></i>
                    </div>
                    <p class="text-sm font-medium">Belum ada riwayat transaksi</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if(file_exists('footer_nav.php')) include 'footer_nav.php'; ?>
        
    </div>
</body>
</html>